/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IConnectionManager;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class StdConnectionManager
implements IConnectionManager {
    private List<RemoteInstrument> m_instrList = new ArrayList<RemoteInstrument>();
    private Component m_uiParentComponent;
    static /* synthetic */ Class class$0;

    public StdConnectionManager(Component parent) {
        this.m_uiParentComponent = parent;
    }

    public int getInstrumentCount() {
        int cnt = this.m_instrList.size();
        return cnt;
    }

    public synchronized RemoteInstrument getInstrument(int instrIndex) {
        if (instrIndex < 0 || instrIndex >= this.m_instrList.size()) {
            return null;
        }
        return this.m_instrList.get(instrIndex);
    }

    public synchronized RemoteInstrument getInstrument(String name) {
        for (RemoteInstrument instr : this.m_instrList) {
            if (instr.getConnection() == null || instr.getConnection().getName().compareToIgnoreCase(name) != 0) continue;
            return instr;
        }
        return null;
    }

    public synchronized void addInstrument(RemoteInstrument instr) {
        this.m_instrList.add(instr);
    }

    public synchronized RemoteInstrument newConnection() {
        RemoteInstrument instr;
        JApplet applet;
        String instrIP = "";
        if (this.m_instrList.size() == 0 && (applet = this.m_uiParentComponent instanceof JApplet ? (JApplet)this.m_uiParentComponent : (JApplet)SwingUtilities.getAncestorOfClass(JApplet.class, this.m_uiParentComponent)) != null) {
            try {
                URL url = applet.getCodeBase();
                instrIP = url.getHost();
            }
            catch (NullPointerException e) {
                instrIP = "";
            }
        }
        if (instrIP.length() == 0) {
            instrIP = QDUtil.getInstrumentIP(this.m_uiParentComponent);
        }
        if ((instr = this.getInstrument(instrIP)) == null) {
            SocketConnection con = new SocketConnection(instrIP);
            instr = new RemoteInstrument(con, null);
            this.m_instrList.add(instr);
        }
        return instr;
    }
}

